//=============================================================================
// Eventtest_Ex_riru.js
//=============================================================================
/*:
 * @plugindesc イベントテストでマップも表示し移動ルートの設定等の確認もできるようになります。テスト起動時に特定のコモン起動機能つき
 * @author riru
 *
 * @param Test Common Id
 * @desc テスト開始時に起動するコモンID。立ち絵の座標変数などを格納する用
 * @default 0
 *
 * @param Test Map Display
 * @desc テスト時マップおよびイベントを表示します。（表示：true、非表示：false）
 * @default true
 *
 * @help
 * イベントテスト拡張プラグイン ver 1.01
 *
 *＜使い方＞
 *テスト開始時に表示されるダイアログボックスにそのイベントがあるマップIDを記入しOKをするとそのマップでイベントが開始されます。
 *そのままやキャンセルを選ぶと従来の黒いマップで開始されます。
 *また、開始の最初にTest Common Idで指定したコモンイベントが起動します。ゲームを通して活用する変数などがある場合はそれらを入れたコモンイベントを用意し指定するといいでしょう
 *移動ルートなどの確認が必要なくダイアログボックスが煩わしい場合はTest Map Displayをfalseに変えてください。コモンイベントのみ起動します
 *（場所移動をすると移動先のマップやイベントが表示されます）
 *
 * ＜規約＞
 * 有償無償問わず使用できます。改変もご自由にどうぞ。使用報告もいりません。２次配布は作成者を偽らなければOKです。
 *著作権は放棄していません。使用する場合は以下の作者とURLをreadmeなどどこかに記載してください
 *
 * ＜作者情報＞
 *作者：riru 
 *HP：ガラス細工の夢幻
 *URL：http://garasuzaikunomugen.web.fc2.com/index.html
 *
 *＜更新履歴＞
 *2016/5/27　イベントIDを記入できるようにし「このイベント」を指定しているものでも反映されるように修正。プレイヤー座標との順番が変わったのでご注意ください
 */

(function() {
    var parameters = PluginManager.parameters('Eventtest_Ex_riru');
    var test_c_id = Number(parameters['Test Common Id'] || 0);
    var display_map = Boolean(parameters['Test Map Display']       === 'true' || false);
    var d_map_id = -1;//riruダイアログのマップID
    var test_player_x = 8;//テストのプレイヤーx
    var test_player_y = 6;//テストのプレイヤーy
    var test_event_id = 0;
Game_Map.prototype.setupTestEvent = function() {//riru再定義
    if ($testEvent) {
    //riruテストイベント用コモン挿入
      var commonEvent = $dataCommonEvents[test_c_id];
   　 if (commonEvent) {
   　   for(var i = commonEvent.list.length-1; i >= 0 ;i--) {
          $testEvent.unshift(commonEvent.list[i]);
        }   
   　 }
   　 //「このイベント」を反映できるように
        this._interpreter.setup($testEvent, test_event_id);
        $testEvent = null;
        return true;
    }
    return false;
};
Scene_Boot.prototype.start = function() {//riru再定義
    Scene_Base.prototype.start.call(this);
    SoundManager.preloadImportantSounds();
    if (DataManager.isBattleTest()) {
        DataManager.setupBattleTest();
        SceneManager.goto(Scene_Battle);
    } else if (DataManager.isEventTest()) {
        DataManager.setupEventTest();
        if(display_map)mapId_form();//riru追加ダイアログボックス生成、マップID入力
        $gamePlayer._newMapId = d_map_id;//riru追加マップID代入
        $gamePlayer._newX = test_player_x;//riru追加プレイヤーX代入
        $gamePlayer._newY = test_player_y;//riru追加プレイヤーY代入
        SceneManager.goto(Scene_Map);
    } else {
        this.checkPlayerLocation();
        DataManager.setupNewGame();
        SceneManager.goto(Scene_Title);
        Window_TitleCommand.initCommandPosition();
    }
    this.updateDocumentTitle();
};
    var mapId_form = function () {
        var mapid = window.prompt("mapId,eventId,playerX,playerY(後ろ3つは省略可"+'\n'+"例）3,5,10　例）3", d_map_id);
            if (mapid &&!mapid.match(/[^0-9|,]/g) && mapid.length > 0) {
             var map_pxy = mapid.split(",");
               d_map_id = Number(map_pxy[0]);
            if (map_pxy[2])test_player_x = Number(map_pxy[2]); 
            if (map_pxy[3])test_player_y = Number(map_pxy[3]); 
            if (map_pxy[1])test_event_id = Number(map_pxy[1]); 
     }else{
                d_map_id = -1;
            }
   
    };
})();
